{{--
    Theme override: Hide product prices across the storefront

    Why this file exists:
    - All storefront templates render prices via EcommerceHelper::viewPath('includes.product-price').
    - By placing a file at the same relative path in the active theme, Laravel will load this file
      instead of the plugin's default view (located at platform/plugins/ecommerce/resources/views/themes/includes/product-price.blade.php).
    - This lets us hide prices without modifying vendor/plugin code and keeps the change reversible.

    Implementation choice:
    - We are NOT deleting the original code; it's preserved below as a commented block for clarity and easy rollback.
    - The view intentionally renders nothing, effectively hiding prices wherever this partial is included
      (product cards, product detail, wishlist, etc.).

    To restore prices later:
    - Either remove this override file, or uncomment the original code block below.
--}}

{{--
    ORIGINAL CODE (commented out on purpose):

    @if (!EcommerceHelper::hideProductPrice() || EcommerceHelper::isCartEnabled())
        @php
            $isDisplayPriceOriginal ??= true;
            $priceWrapperClassName ??= null;
            $priceClassName ??= null;
            $priceOriginalClassName ??= null;
            $priceOriginalWrapperClassName ??= null;
        @endphp

        <div class="{{ $priceWrapperClassName === null ? 'bb-product-price mb-3' : $priceWrapperClassName }}">
            <span
                class="{{ $priceClassName === null ? 'bb-product-price-text fw-bold' : $priceClassName }}"
                data-bb-value="product-price"
            >{{ $product->price()->displayAsText() }}</span>

            @if ($isDisplayPriceOriginal && $product->isOnSale())
                @include(EcommerceHelper::viewPath('includes.product-prices.original'), [
                    'priceWrapperClassName' => $priceOriginalWrapperClassName,
                    'priceClassName' => $priceOriginalClassName,
                ])
            @endif
        </div>
    @endif
--}}

{{--
    Render nothing by design to hide prices.
--}}
