<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('ec_product_categories', function (Blueprint $table) {
            $table->string('pdf_file')->nullable()->after('icon_image');
            $table->string('pdf_title')->nullable()->after('pdf_file');
            $table->text('pdf_description')->nullable()->after('pdf_title');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('ec_product_categories', function (Blueprint $table) {
            $table->dropColumn(['pdf_file', 'pdf_title', 'pdf_description']);
        });
    }
};
