$(() => {
    'use strict'

    const loadAjaxCart = (data) => {
        $('.cartmini__area').html(data.cart_mini)
        $('[data-bb-value="cart-count"]').text(data.count)

        const $cartArea = $('.tp-cart-area')

        if ($cartArea.length) {
            $cartArea.replaceWith(data.cart_content)
        }

        if (data.additional_cart_data) {
            Object.keys(data.additional_cart_data).forEach(key => {
                $(`[data-bb-value="${key}"]`).text(data.additional_cart_data[key])
            })
        }

        if (typeof Theme.lazyLoadInstance !== 'undefined') {
            Theme.lazyLoadInstance.update()
        }
    }

    const handleUpdateCart = (element) => {
        let form

        if (element) {
            form = $(element).closest('form')
        } else {
            form = $('form.cart-form')
        }

        $.ajax({
            type: 'POST',
            url: form.prop('action'),
            data: form.serialize(),
            success: ({error, message, data}) => {
                if (error) {
                    Theme.showError(message)
                }

                loadAjaxCart(data)
            },
            error: (error) => Theme.handleError(error),
        })
    }

    /**
     * @param {Array<Number>} data
     * @param {jQuery} element
     */
    window.onBeforeChangeSwatches = (data, element) => {
        const form = element.closest('form')

        if (data) {
            form.find('button[type="submit"]').prop('disabled', true)
            form.find('button[data-bb-toggle="add-to-cart"]').prop('disabled', true)
        }
    }

    $(document)
        .on('click', '[data-bb-toggle="remove-coupon"]', (e) => {
            e.preventDefault()

            const currentTarget = $(e.currentTarget)

            $.ajax({
                url: currentTarget.prop('href'),
                type: 'POST',
                success: ({error, message}) => {
                    if (error) {
                        Theme.showError(message)

                        return
                    }

                    Theme.showSuccess(message)

                    handleUpdateCart()
                },
                error: (error) => Theme.handleError(error),
            })
        })
        .on('click', '[data-bb-toggle="decrease-qty"]', (e) => {
            const $input = $(e.currentTarget).parent().find('input')

            let count = parseInt($input.val()) - 1
            count = count < 1 ? 1 : count
            $input.val(count)
            $input.trigger('change')
        })
        .on('click', '[data-bb-toggle="increase-qty"]', (e) => {
            const $input = $(e.currentTarget).parent().find('input')

            const max = $input.prop('max')

            if (max && parseInt($input.val()) >= parseInt(max)) {
                return
            }

            $input.val(parseInt($input.val()) + 1)
            $input.trigger('change')
        })
        .on('change', '[data-bb-toggle="update-cart"]', (e) => {
            handleUpdateCart(e.currentTarget)
        })
        .on('click', '[data-bb-toggle="change-product-filter-layout"]', (e) => {
            e.preventDefault()

            const currentTarget = $(e.currentTarget)

            currentTarget.addClass('active')
            currentTarget.closest('li').siblings().find('button').removeClass('active')

            $('.bb-product-form-filter').find('[name="layout"]').val(currentTarget.data('value')).trigger('change')
        })
        .on('click', '[data-bb-toggle="copy-coupon"]', async (e) => {
            e.preventDefault()

            const currentTarget = $(e.currentTarget)
            const value = currentTarget.data('value')
            const previousText = currentTarget.find('span').text()

            if (navigator.clipboard) {
                await navigator.clipboard.writeText(value)
            } else {
                const tempInput = document.createElement('input')
                tempInput.value = value
                document.body.appendChild(tempInput)
                tempInput.select()
                document.execCommand('copy')
                document.body.removeChild(tempInput)
            }

            currentTarget.find('span').text(currentTarget.data('copied-message'))

            setTimeout(() => currentTarget.find('span').text(previousText), 2000)
        })
        .on('click', '[data-bb-toggle="scroll-to-review"]', (e) => {
            if ($('.nav-tabs button#nav-review-tab').length) {
                e.preventDefault()

                const $tab = $('.nav-tabs button#nav-review-tab')
                const $container = $('.product-review-container')

                if ($tab.length && $container.length) {
                    $tab.tab('show')

                    $('html, body').animate({
                        scrollTop: $container.offset().top - 100,
                    })
                }
            }
        })
        .on('show.bs.modal', '#product-quick-view-modal', (e) => {
            const modal = $(e.currentTarget)
            const trigger = $(e.relatedTarget)

            $.ajax({
                url: trigger.data('url') || trigger.prop('href'),
                type: 'GET',
                beforeSend: () => {
                    trigger.addClass('btn-loading')
                    modal.find('.modal-content').css('min-height', '40rem').html('<div class="loading-spinner"></div>')
                },
                success: ({error, data}) => {
                    if (error) {
                        return
                    }

                    modal.find('.modal-content').css('min-height', '0').html(data)

                    if (typeof Theme.lazyLoadInstance !== 'undefined') {
                        Theme.lazyLoadInstance.update()
                    }

                    setTimeout(() => {
                        EcommerceApp.initProductGallery(true)
                    }, 100)

                    document.dispatchEvent(new CustomEvent('ecommerce.quick-view.initialized'))
                },
                complete: () => trigger.removeClass('btn-loading'),
            })
        })
        .on('submit', 'form#coupon-form', (e) => {
            e.preventDefault()

            const currentTarget = $(e.currentTarget)
            const button = currentTarget.find('button[type="submit"]')

            $.ajax({
                url: currentTarget.prop('action'),
                type: 'POST',
                data: currentTarget.serialize(),
                beforeSend: () => button.prop('disabled', true).addClass('btn-loading'),
                success: ({error, message}) => {
                    if (error) {
                        Theme.showError(message)

                        return
                    }

                    Theme.showSuccess(message)

                    handleUpdateCart()
                },
                error: (error) => Theme.handleError(error),
                complete: () => button.prop('disabled', false).removeClass('btn-loading'),
            })
        })
        .on('keyup', 'form#coupon-form input', (e) => {
            const currentTarget = $(e.currentTarget)

            currentTarget.closest('form').find('button[type="submit"]').prop('disabled', !currentTarget.val())
        })
        .on('click', '.product-form button[type="submit"]', (e) => {
            e.preventDefault()

            const currentTarget = $(e.currentTarget)

            // Prevent multiple submissions
            if (currentTarget.prop('disabled') || currentTarget.hasClass('btn-loading')) {
                return
            }

            const form = currentTarget.closest('form')
            const data = form.serializeArray()

            if (form.find('input[name="id"]').val() === '') {
                return
            }

            data.push({name: 'checkout', value: currentTarget.prop('name') === 'checkout' ? 1 : 0})

            $.ajax({
                type: 'POST',
                url: form.prop('action'),
                data: data,
                beforeSend: () => {
                    // Only disable and add loading to the clicked button
                    currentTarget.prop('disabled', true).addClass('btn-loading')
                    // Disable other submit buttons without loading animation
                    form.find('button[type="submit"]').not(currentTarget).prop('disabled', true)
                },
                success: ({error, message, data}) => {
                    if (error) {
                        Theme.showError(message)

                        if (data?.next_url !== undefined) {
                            setTimeout(() => {
                                window.location.href = data.next_url
                            }, 500);
                        }

                        return
                    }

                    form.find('input[name="qty"]').val(1)

                    if (data?.next_url !== undefined) {
                        window.location.href = data.next_url
                    } else {
                        loadAjaxCart(data)

                        // Close quick shop modal if it's open
                        const quickShopModal = $('#quick-shop-modal')
                        if (quickShopModal.length && quickShopModal.hasClass('show')) {
                            const modalInstance = bootstrap.Modal.getInstance(quickShopModal[0])
                            if (modalInstance) {
                                modalInstance.hide()
                            }
                        }

                        // Check if auto open mini cart is enabled
                        if (window.themeOptions && window.themeOptions.ecommerce_auto_open_mini_cart === 'yes') {
                            $('.cartmini__area').addClass('cartmini-opened')
                            $('.body-overlay').addClass('opened')
                        }
                    }
                },
                error: (error) => Theme.handleError(error),
                complete: () => {
                    // Re-enable all submit buttons in the form
                    form.find('button[type="submit"]').prop('disabled', false).removeClass('btn-loading')
                },
            })
        })
        .on('click', '.js-sale-popup-quick-view-button', (e) => {
            e.preventDefault()

            $('#product-quick-view-modal').modal('show', e.currentTarget)
        })
        .on('change', '.tp-shop-top-select select', (e) => {
            const currentTarget = $(e.currentTarget)

            const form = $('.bb-product-form-filter')

            form.find(`input[name="${currentTarget.prop('name')}"]`)
                .val(currentTarget.val())
                .trigger('submit')
        })
        .on('click', '.bb-product-items-wrapper .pagination a', (e) => {
            e.preventDefault()

            const currentTarget = $(e.currentTarget)

            const url = new URL(currentTarget.prop('href'))
            const page = url.searchParams.get('page')

            $('.bb-product-form-filter').find('[name="page"]').val(page).trigger('change')
        })
        .on('submit', 'form.subscribe-form', (e) => {
            e.preventDefault()

            const $form = $(e.currentTarget)
            const $button = $form.find('button[type=submit]')

            $.ajax({
                type: 'POST',
                cache: false,
                url: $form.prop('action'),
                data: new FormData($form[0]),
                contentType: false,
                processData: false,
                beforeSend: () => $button.prop('disabled', true).addClass('btn-loading'),
                success: ({error, message}) => {
                    if (error) {
                        Theme.showError(message)

                        return
                    }

                    $form.find('input').val('')

                    Theme.showSuccess(message)

                    document.dispatchEvent(new CustomEvent('newsletter.subscribed'))
                },
                error: (error) => {
                    if (typeof refreshRecaptcha !== 'undefined') {
                        refreshRecaptcha()
                    }

                    Theme.handleError(error)
                },
                complete: () => {
                    if (typeof refreshRecaptcha !== 'undefined') {
                        refreshRecaptcha()
                    }

                    $button.prop('disabled', false).removeClass('btn-loading')
                },
            })
        })
        .on('click', '[data-bb-toggle="product-tab"]', (e) => {
            e.preventDefault()

            const currentTarget = $(e.currentTarget)

            const tabPane = currentTarget.closest('.tp-product-area').find('#productTabContent .tab-pane')
            const wrapper = tabPane.closest('.tp-product-area')
            const tooltip = currentTarget.find('span.tp-product-tab-tooltip')

            // Assuming currentTarget, tooltip, wrapper, and tabPane are already defined
            const url = `${currentTarget.closest('#productTab').data('ajax-url')}&type=${currentTarget.data('bb-value')}`;

            fetch(url, {
                method: 'GET',
                headers: {
                    'Content-Type': 'application/json', // Requesting JSON response
                    'Accept': 'application/json', // Requesting JSON response
                },
            })
                .then(response => {
                    // Check if the response is okay and parse it as JSON
                    if (!response.ok) {
                        throw new Error('Network response was not ok');
                    }
                    return response.json();
                })
                .then(({data}) => {
                    // Update tooltip text and tabPane with the fetched data
                    tooltip.text(data.count);
                    tabPane.html(data.html);

                    // Update lazyLoadInstance if it exists
                    if (typeof Theme.lazyLoadInstance !== 'undefined') {
                        Theme.lazyLoadInstance.update();
                    }
                })
                .catch(error => {
                    // Handle any errors during the fetch
                    Theme.handleError(error);
                })
                .finally(() => {
                    // Remove the loading spinner
                    $('.loading-spinner').remove();
                });

            // Before sending the request, update the tooltip and show a loading spinner
            tooltip.text('...');
            wrapper.append('<div class="loading-spinner"></div>');
        })
        .on('submit', '.contact-form', (e) => {
            e.preventDefault()

            const $form = $(e.currentTarget)
            const $button = $form.find('button[type=submit]')

            $.ajax({
                type: 'POST',
                cache: false,
                url: $form.prop('action'),
                data: new FormData($form[0]),
                contentType: false,
                processData: false,
                beforeSend: () => $button.addClass('button-loading'),
                success: ({error, message}) => {
                    if (!error) {
                        $form[0].reset()
                        Theme.showSuccess(message)
                        // Close enquiry modal if submission came from there
                        const $modal = $form.closest('.modal')
                        if ($modal.length) {
                            const instance = bootstrap.Modal.getInstance($modal[0])
                            if (instance) instance.hide()
                        }
                    } else {
                        Theme.showError(message)
                    }
                },
                error: (error) => Theme.handleError(error),
                complete: () => {
                    if (typeof refreshRecaptcha !== 'undefined') {
                        refreshRecaptcha()
                    }

                    $button.removeClass('button-loading')
                },
            })
        })
        .on('show.bs.modal', '#emailEnquiryModal', (e) => {
            const modal = $(e.currentTarget)
            const productName = modal.data('product-name')
            const productUrl = modal.data('product-url')
            const $form = modal.find('form.contact-form')

            // Ensure theme overlay doesn't block the modal
            $('.body-overlay').removeClass('opened')
            modal.css('z-index', 20000)

            // Prefill subject/content if present
            const $subject = $form.find('input[name="subject"]')
            const $content = $form.find('textarea[name="content"]')

            if ($subject.length) {
                $subject.val(`${Theme.trans ? Theme.trans('Enquiry about') : 'Enquiry about'}: ${productName}`)
            }

            if ($content.length && !$content.val()) {
                $content.val(`${productName}\n${productUrl}`)
            }

            // Update submit button label and size
            const $submit = $form.find('button[type="submit"]')
            if ($submit.length) {
                $submit.text(Theme.trans ? Theme.trans('Send an enquiry') : 'Send an enquiry')
                $submit.addClass('w-100')
                $submit.css({ padding: '12px 24px' })
            }

            // Backdrop is disabled via data-bs-backdrop="false" on the modal

            // Add background blur while modal is open
            $('body').addClass('email-enquiry-blur')
        })
        .on('hidden.bs.modal', '#emailEnquiryModal', () => {
            // Remove background blur when modal closes
            $('body').removeClass('email-enquiry-blur')
        })
        // Close when clicking on the modal backdrop area (modal surface outside dialog)
        .on('mousedown', '#emailEnquiryModal', (e) => {
            // If click target is the modal element itself (outside .modal-dialog), close it
            if (e.target === e.currentTarget) {
                const instance = bootstrap.Modal.getInstance(e.currentTarget)
                if (instance) instance.hide()
            }
        })
        // Close modal when clicking outside the dialog (no backdrop case)
        .on('mousedown', (e) => {
            const $openModal = $('#emailEnquiryModal.show')
            if (!$openModal.length) return
            const clickedInsideDialog = $(e.target).closest('#emailEnquiryModal .modal-dialog').length > 0
            if (!clickedInsideDialog) {
                const instance = bootstrap.Modal.getInstance($openModal[0])
                if (instance) instance.hide()
            }
        })
        .on('click', '.sticky-actions-button button', (e) => {
            e.preventDefault()

            const currentTarget = $(e.currentTarget)
            const form = $('form.product-form')

            if (currentTarget.prop('name') === 'add-to-cart') {
                form.find('button[type="submit"][name="add-to-cart"]').trigger('click')
            }

            if (currentTarget.prop('name') === 'checkout') {
                form.find('button[type="submit"][name="checkout"]').trigger('click')
            }
        })
        .on('click', '[data-bb-toggle="open-mini-cart"]', (e) => {
            $('[data-bb-toggle="mini-cart-content-slot"]').html('<div class="loading-spinner"></div>')

            $.ajax({
                url: $(e.currentTarget).data('url'),
                type: 'GET',
                success: ({data}) => {
                    $('[data-bb-toggle="mini-cart-content-slot"]').html(data.content)
                    $('[data-bb-toggle="mini-cart-footer-slot"]').html(data.footer)

                    if (typeof Theme.lazyLoadInstance !== 'undefined') {
                        Theme.lazyLoadInstance.update()
                    }
                },
                error: (error) => Theme.handleError(error),
            })
        })

    document.addEventListener('ecommerce.quick-view.initialized', () => {
        const $countDown = $(document).find('[data-countdown]')

        if (! $($countDown).length || ! $.fn.countdown) {
            return
        }

        $countDown.countdown()
    })

    document.addEventListener('ecommerce.cart.added', (e) => {
        const {data, element, message} = e.detail

        loadAjaxCart(data)

        // Check if auto open mini cart is enabled
        if (window.themeOptions && window.themeOptions.ecommerce_auto_open_mini_cart === 'yes') {
            $('.cartmini__area').addClass('cartmini-opened')
            $('.body-overlay').addClass('opened')
        } else {
            Theme.showSuccess(message)
        }
    })

    document.addEventListener('ecommerce.cart.removed', (e) => {
        const {data} = e.detail
        if (data.count === 0) {
            $('.cartmini__area').removeClass('cartmini-opened')
            $('.body-overlay').removeClass('opened')
        }

        loadAjaxCart(data)
    })

    document.addEventListener('ecommerce.wishlist.removed', (e) => {
        const {data, element} = e.detail

        element.closest('tr').remove()

        if (data.count === 0) {
            window.location.reload()
        }
    })

    document.addEventListener('ecommerce.compare.added', (e) => {
        const {element} = e.detail

        if (element.find('span')) {
            element
                .find('span')
                .text(
                    element.hasClass('active')
                        ? element.data('remove-text')
                        : element.data('add-text')
                )
        }
    })

    document.addEventListener('ecommerce.wishlist.added', (e) => {
        const {data, element} = e.detail

        data.added ? element.addClass('active') : element.removeClass('active')

        if (element.find('span')) {
            element
                .find('span')
                .text(data.added ? element.data('remove-text') : element.data('add-text'))
        }
    })

    document.addEventListener('ecommerce.compare.removed', (e) => {
        const {element} = e.detail

        if (element.find('span')) {
            element
                .find('span')
                .text(
                    element.hasClass('active')
                        ? element.data('remove-text')
                        : element.data('add-text')
                )
        }
    })

    document.addEventListener('ecommerce.product-filter.before', () => {
        $('.tp-shop-area > .container, .bb-shop-detail > .container > .bb-shop-tab-content').append(
            '<div class="loading-spinner"></div>'
        )
    })

    document.addEventListener('ecommerce.product-filter.success', (e) => {
        const {data} = e.detail

        $('.bb-product-items-wrapper').html(data.data)

        if (data.additional) {
            $('.bb-shop-sidebar').replaceWith(data.additional.filters_html)
        }

        $('.tp-shop-top-result p').text(data.message)

        $('html, body').animate({
            scrollTop: $('.tp-shop-main-wrapper').offset().top - 120,
        })
    })

    document.addEventListener('ecommerce.product-filter.completed', () => {
        $('.tp-shop-area > .container, .bb-shop-detail > .container > .bb-shop-tab-content').find('.loading-spinner').remove()
    })

    document.addEventListener('ecommerce.quick-shop.before-send', (e) => {
        const {element, modal} = e.detail

        element.addClass('btn-loading')
        modal.find('.modal-body').css('min-height', '16rem').html('<div class="loading-spinner"></div>')
    })

    document.addEventListener('ecommerce.quick-shop.completed', (e) => {
        const {element, modal} = e.detail

        element.removeClass('btn-loading')
        modal.find('.modal-body').css('min-height', '0')
    })

    if (window.location.hash === '#product-review') {
        $(document).find('[data-bb-toggle="scroll-to-review"]').trigger('click')
    }

    document.addEventListener('shortcode.loaded', () => {
        const $countDown = $(document).find('[data-countdown]')

        if (! $($countDown).length || ! $.fn.countdown) {
            return
        }

        $countDown.countdown()
    })

    // Email Enquiry Modal - Product Data Injection
    $(document)
        .on('show.bs.modal', '#emailEnquiryModal', function (event) {
            const button = event.relatedTarget
            if (!button) return

            const productName = button.getAttribute('data-product-name')
            const productUrl = button.getAttribute('data-product-url')
            const modal = $(this)
            const form = modal.find('form')

            // Show product info in modal
            if (productName) {
                modal.find('#modal-product-name').text(productName)
                modal.find('#product-info').show()
            }

            // Add hidden fields for product context
            let productNameField = form.find('input[name="product_name"]')
            if (productNameField.length === 0) {
                productNameField = $('<input type="hidden" name="product_name">')
                form.append(productNameField)
            }
            productNameField.val(productName)

            let productUrlField = form.find('input[name="product_url"]')
            if (productUrlField.length === 0) {
                productUrlField = $('<input type="hidden" name="product_url">')
                form.append(productUrlField)
            }
            productUrlField.val(productUrl)

            // Pre-fill subject and message
            const subjectField = form.find('input[name="subject"]')
            if (subjectField.length > 0 && productName) {
                subjectField.val(`Product Enquiry: ${productName}`)
            }

            const messageField = form.find('textarea[name="content"]')
            if (messageField.length > 0 && productName && productUrl) {
                const prefillMessage = `Hi,\n\nI am interested in the following product:\n\nProduct: ${productName}\nURL: ${productUrl}\n\nPlease provide me with more information including pricing, availability, and specifications.\n\nThank you.`
                messageField.val(prefillMessage)
            }
        })
        .on('hidden.bs.modal', '#emailEnquiryModal', function () {
            // Reset form when modal closes
            const modal = $(this)
            const form = modal.find('form')

            // Reset form fields
            form[0].reset()

            // Remove product-specific hidden fields
            form.find('input[name="product_name"], input[name="product_url"]').remove()

            // Hide product info
            modal.find('#product-info').hide()

            // Clear any success/error messages
            modal.find('.alert-success, .alert-danger').remove()
        })
        .on('submit', '#emailEnquiryModal form', function (e) {
            e.preventDefault()

            const form = $(this)
            const modal = form.closest('.modal')
            const submitBtn = form.find('button[type="submit"]')
            const originalBtnText = submitBtn.text()

            // Show loading state
            submitBtn.prop('disabled', true).text('Sending...')
            modal.find('.contact-form-wrapper').addClass('loading')

            // Remove previous messages
            modal.find('.alert-success, .alert-danger').remove()

            // Submit via AJAX
            $.ajax({
                url: form.attr('action'),
                method: 'POST',
                data: form.serialize(),
                success: function (response) {
                    // Show success message
                    const successMsg = $('<div class="alert alert-success">')
                        .html('<strong>Thank you!</strong> Your enquiry has been sent successfully. We will get back to you soon.')
                    modal.find('.modal-body').prepend(successMsg)

                    // Reset form after short delay
                    setTimeout(() => {
                        modal.modal('hide')
                    }, 2000)
                },
                error: function (xhr) {
                    // Show error message
                    let errorMsg = 'An error occurred. Please try again.'
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        errorMsg = xhr.responseJSON.message
                    }

                    const errorAlert = $('<div class="alert alert-danger">')
                        .html(`<strong>Error!</strong> ${errorMsg}`)
                    modal.find('.modal-body').prepend(errorAlert)
                },
                complete: function () {
                    // Reset loading state
                    submitBtn.prop('disabled', false).text(originalBtnText)
                    modal.find('.contact-form-wrapper').removeClass('loading')
                }
            })
        })
})
