<?php
    Theme::asset()->container('footer')->usePath()->add('range-slider', 'js/range-slider.js');
    $listingLayout = products_listing_layout();

    $hasFilters = EcommerceHelper::hasAnyProductFilters();
?>

<?php echo apply_filters('ads_render', null, 'listing_page_before'); ?>


<div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['row', 'flex-row-reverse' => $listingLayout === 'right-sidebar' && $hasFilters]); ?>">
    <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['col-xl-3 col-lg-4' => $listingLayout !== 'no-sidebar' && $hasFilters, 'col-12' => $listingLayout === 'no-sidebar']); ?>">
        <?php echo $__env->make(Theme::getThemeNamespace('views.ecommerce.includes.filters-sidebar'), array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>

    <?php if($listingLayout !== 'no-sidebar' && $hasFilters): ?>
        <div class="col-xl-9 col-lg-8">
            <?php endif; ?>
            <div class="tp-shop-main-wrapper">
                <?php echo $__env->make(EcommerceHelper::viewPath('includes.product-listing-page-description'), array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                <?php echo $__env->make(EcommerceHelper::viewPath('includes.product-filters-top'), array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                <div class="bb-product-items-wrapper tp-shop-item-primary">
                    <?php echo $__env->make(Theme::getThemeNamespace('views.ecommerce.includes.product-items'), array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
            </div>
            <?php if($listingLayout !== 'no-sidebar'): ?>
        </div>
    <?php endif; ?>
</div>

<?php echo apply_filters('ads_render', null, 'listing_page_after'); ?>

<?php /**PATH E:\Projects\interplusnew\platform\themes/shofy/views/ecommerce/includes/products-listing.blade.php ENDPATH**/ ?>