<div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['tp-product-item transition-3 mb-25', 'tp-product-item-3 tp-product-style-primary mb-50' => $style === 3, $class ?? null]); ?>">
    <div class="tp-product-thumb p-relative fix m-img">
        <a href="<?php echo e($product->url); ?>">
            <?php echo e(RvMedia::image($product->image, $product->name, 'medium')); ?>

        </a>

        <?php echo $__env->make(Theme::getThemeNamespace('views.ecommerce.includes.product.badges'), array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <?php echo $__env->make(Theme::getThemeNamespace('views.ecommerce.includes.product.style-1.actions'), array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>

    <div class="tp-product-content">
        <?php echo apply_filters('ecommerce_before_product_item_content_renderer', null, $product); ?>


        <?php if(is_plugin_active('marketplace') && $product->store?->id): ?>
            <div class="tp-product-category tp-store-name">
                <a href="<?php echo e($product->store->url); ?>"><?php echo e($product->store->name); ?></a> <?php echo $product->store->badge; ?>

            </div>
        <?php endif; ?>
        <h3 class="<?php echo \Illuminate\Support\Arr::toCssClasses(['tp-product-title', theme_option('ecommerce_product_name_lines', '2') === '1' ? 'line-clamp-1' : 'line-clamp-2']); ?>">
            <a href="<?php echo e($product->url); ?>" title="<?php echo e($product->name); ?>">
                <?php echo e($product->name); ?>

            </a>
        </h3>

        <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['tp-product-price-review' => theme_option('product_listing_review_style', 'default') !== 'default' && EcommerceHelper::isReviewEnabled() && ($product->reviews_avg || theme_option('ecommerce_hide_rating_star_when_is_zero', 'no') === 'no')]); ?>">
            <?php echo $__env->make(Theme::getThemeNamespace('views.ecommerce.includes.product.style-1.rating'), array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <?php echo $__env->make(Theme::getThemeNamespace('views.ecommerce.includes.product.style-1.price'), array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>

        <?php if($withCountdown ?? false): ?>
            <?php echo $__env->make(Theme::getThemeNamespace('views.ecommerce.includes.product.countdown'), compact('endDate'), array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php endif; ?>

        <?php echo apply_filters('ecommerce_after_product_item_content_renderer', null, $product); ?>

    </div>
</div>
<?php /**PATH E:\Projects\interplusnew\platform\themes/shofy/views/ecommerce/includes/product/style-1/grid.blade.php ENDPATH**/ ?>