<?php if(
    is_plugin_active('announcement')
    && ! \ArchiElite\Announcement\AnnouncementHelper::isHideOnMobile()
    && \ArchiElite\Announcement\Models\Announcement::query()->available()->exists()
): ?>
    <style>
        @media (max-width: 767px) {
            .tp-header-transparent {
                top: 3.5rem;
            }
        }
    </style>
<?php endif; ?>

<header>
    <?php echo Theme::partial('header.top', ['colorMode' => 'light', 'headerTopClass' => 'container-fluid pl-45 pr-45', 'showUserMenu' => true]); ?>


    <div
        id="header-sticky"
        class="<?php echo \Illuminate\Support\Arr::toCssClasses(['tp-header-area tp-header-sticky has-dark-logo tp-header-height', 'header-main' => ! Theme::get('hasSlider'), 'tp-header-style-transparent-white tp-header-transparent' => Theme::get('hasSlider')]); ?>"
        <?php echo Theme::partial('header.sticky-data'); ?>

    >
        <div class="tp-header-bottom-3 pl-35 pr-35" style="background-color: <?php echo e($headerMainBackgroundColor); ?>; color: <?php echo e($headerMainTextColor); ?>">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-xl-2 col-lg-2 col-6">
                        <?php echo Theme::partial('header.logo', ['hasLogoLight' => true]); ?>

                    </div>
                    <div class="col-xl-8 col-lg-8 d-none d-lg-block">
                        <div class="main-menu menu-style-3 p-relative d-flex align-items-center justify-content-center">
                            <nav class="tp-main-menu-content">
                                <?php echo Menu::renderMenuLocation('main-menu', ['view' => 'main-menu']); ?>

                            </nav>
                        </div>
                        <?php if(is_plugin_active('ecommerce')): ?>
                            <div class="tp-category-menu-wrapper d-none">
                                <nav class="tp-category-menu-content">
                                    <?php echo Theme::partial('header.categories-dropdown'); ?>

                                </nav>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-xl-2 col-lg-2 col-6">
                        <?php echo Theme::partial('header.actions', ['class' => 'justify-content-end ml-50', 'showSearchButton' => true]); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</header>
<?php /**PATH E:\Projects\interplusnew\platform\themes/shofy/partials/header/styles/header-3.blade.php ENDPATH**/ ?>