<?php

// Script to update category order in database
// Run this with: php update_category_order.php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use Botble\Ecommerce\Models\ProductCategory;

// Your desired order mapping
$categoryOrder = [
    59 => 1,   // Small Fireproof Safes
    60 => 2,   // Medium Fireproof Safes
    61 => 3,   // Large Fireproof Safes
    42 => 4,   // Fireproof Filing Cabinets
    50 => 5,   // Small Bankers Safes
    54 => 6,   // Large Bankers Safes
    48 => 7,   // Night Deposit Safes
    55 => 8,   // Strong Room Doors
    57 => 9,   // Hotel Safes
    47 => 10,  // Cash Boxes
    65 => 11,  // Time Locks
    72 => 12,  // Note Counter Machines
    70 => 13,  // Paper Shredders
    67 => 14,  // Safe Deposit Boxes
    43 => 15,  // Digital Key Cabinets
    66 => 16,  // None Fire-Resistant Safe Boxes
    46 => 17,  // Gun Safes
];

echo "Updating category order...\n";

foreach ($categoryOrder as $categoryId => $order) {
    $category = ProductCategory::find($categoryId);
    if ($category) {
        $category->order = $order;
        $category->save();
        echo "Updated {$category->name} (ID: {$categoryId}) to order {$order}\n";
    } else {
        echo "Category with ID {$categoryId} not found\n";
    }
}

echo "Category order update completed!\n";
